/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.ria.servlet;

import com.ejie.ria.patrones.RiaCombos;
import com.ejie.ria.servlet.RiaJSMin;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Iterator;
import java.util.zip.GZIPOutputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.lang.StringUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class RiaCombosServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/javascript;charset=iso-8859-1");
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setStatus(200);
        String encoding = request.getHeader("Accept-Encoding");
        if (this.isGzipEncodingAvaible(encoding)) {
            response.setHeader("Content-Encoding", "gzip");
        }
        String tabla = request.getParameter("tabla");
        String where = request.getParameter("where");
        String idioma = request.getParameter("idioma");
        String jsonResponse = "[]";
        String[] padres = new String[]{};
        if (request.getParameterValues("val[]") != null) {
            padres = request.getParameterValues("val[]");
        } else if (request.getParameter("val") != null) {
            padres = new String[]{request.getParameter("val")};
        }
        String[] filtros = new String[]{};
        if (request.getParameterValues("colFiltro[]") != null) {
            filtros = request.getParameterValues("colFiltro[]");
        } else if (request.getParameter("colFiltro") != null) {
            filtros = new String[]{request.getParameter("colFiltro")};
        }
        if (padres != null && padres.length != 0) {
            jsonResponse = this.getData(idioma, tabla, where, padres, filtros);
        }
        if (this.isGzipEncodingAvaible(encoding)) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            RiaJSMin jsmin = new RiaJSMin(new ByteArrayInputStream(jsonResponse.getBytes()), baos);
            this.doJsmin(jsmin);
            ServletOutputStream o = response.getOutputStream();
            GZIPOutputStream gz = new GZIPOutputStream((OutputStream)o);
            gz.write(baos.toString().getBytes());
            gz.close();
            o.close();
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            this.doGet(req, resp);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean isGzipEncodingAvaible(String encoding) {
        return encoding != null && encoding.indexOf("gzip") >= 0;
    }

    private void doJsmin(RiaJSMin jsmin) {
        try {
            jsmin.jsmin();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (RiaJSMin.UnterminatedRegExpLiteralException e) {
            e.printStackTrace();
        }
        catch (RiaJSMin.UnterminatedCommentException e) {
            e.printStackTrace();
        }
        catch (RiaJSMin.UnterminatedStringLiteralException e) {
            e.printStackTrace();
        }
    }

    private String getData(String idioma, String tabla, String where, String[] padres, String[] filtros) {
        StringBuffer sbCondiciones = new StringBuffer("");
        String valPadre = "";
        String columnaFiltro = "";
        int i = 0;
        while (i < padres.length) {
            valPadre = padres[i];
            columnaFiltro = filtros[i];
            if (StringUtils.isEmpty((String)columnaFiltro)) {
                columnaFiltro = RiaCombos.getColumnaValor(tabla);
            }
            if (StringUtils.isNotEmpty((String)valPadre) && !"null".equals(valPadre)) {
                sbCondiciones.append(columnaFiltro).append("=").append(valPadre).append(" AND ");
            }
            ++i;
        }
        String condiciones = sbCondiciones.toString();
        if (!condiciones.equals("")) {
            condiciones = condiciones.substring(0, condiciones.length() - 5);
        }
        String whereT = null;
        if (!condiciones.equals("")) {
            whereT = StringUtils.isNotEmpty((String)where) ? String.valueOf(condiciones) + " AND " + where : condiciones.toString();
        } else if (StringUtils.isNotEmpty((String)where)) {
            whereT = where;
        }
        Collection data = RiaCombos.getData(tabla, whereT, idioma);
        JSONArray filas = new JSONArray();
        if (RiaCombos.getColumnaTipo(tabla).equals("int") || RiaCombos.getColumnaTipo(tabla).equals("integer")) {
            Iterator iterator = data.iterator();
            while (iterator.hasNext()) {
                DynaBean object = (DynaBean)iterator.next();
                String desc = (String)object.get(RiaCombos.getColumnaDescripcion(tabla));
                BigDecimal value = (BigDecimal)object.get(RiaCombos.getColumnaValor(tabla));
                filas.put((Object)this.doFila(valPadre, value.toString(), desc));
            }
        } else {
            Iterator iterator = data.iterator();
            while (iterator.hasNext()) {
                DynaBean object = (DynaBean)iterator.next();
                String desc = (String)object.get(RiaCombos.getColumnaDescripcion(tabla));
                String value = (String)object.get(RiaCombos.getColumnaValor(tabla));
                filas.put((Object)this.doFila(valPadre, value, desc));
            }
        }
        return filas.toString();
    }

    private JSONObject doFila(String valPadre, String value, String desc) {
        JSONObject fila = new JSONObject();
        try {
            fila.put("When", (Object)valPadre);
            fila.put("Value", (Object)value);
            fila.put("Text", (Object)desc);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return fila;
    }
}

